﻿/* Copyright 2015 Intellica Corporation 
Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at
    http://www.apache.org/licenses/LICENSE-2.0
Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/
using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Data;
using DataAccess;

/// <summary>
/// Methods and properties used to write a TIU note
/// </summary>
public class CNote
{

   /// <summary>
   /// Default constructor
   /// </summary>
	public CNote()
	{
		//
		// TODO: Add constructor logic here
		//
	}
       
    /// <summary>
    /// US:6048 Gets all clinics for a site/region
    /// </summary>
    /// <param name="BaseMstr"></param>
    /// <param name="lRegionID"></param>
    /// <param name="lSiteID"></param>
    /// <returns></returns>
    public DataSet GetClinicDS(BaseMaster BaseMstr,
                               string strSearch)
    {

        BaseMstr.Session["PING_MDWS"] = "1";

        //status info
        long lStatusCode = -1;
        string strStatusComment = "";

        //transfer clinics before running query
        if (BaseMstr.MDWSTransfer)
        {
            CMDWSOps ops = new CMDWSOps(BaseMstr.GetDataObject());
            CStatus status = ops.TransferClinics(strSearch);
            if (!status.Status)
            {
                //todo: BaseMstr.ShowSystemFeedback(status.StatusComment, "Data Transfer Error");
            }
        }
        
        //create a new parameter list with standard params from basemstr
        CDataParameterList plist = new CDataParameterList(BaseMstr.ASPSessionID,
                                                          BaseMstr.ClientIP,
                                                          BaseMstr.FXUserID);

        plist.AddInputParameter("pi_nRegionID", BaseMstr.RegionID);
        plist.AddInputParameter("pi_nSiteID", BaseMstr.SiteID);
        plist.AddInputParameter("pi_vSearch", strSearch);

        //call sp to get ds
        CDataSet cds = new CDataSet();
        DataSet ds = cds.GetOracleDataSet(BaseMstr.DBConn,
                                           "PCK_NOTE.GetClinicRS",
                                            plist,
                                            out lStatusCode,
                                            out strStatusComment);

        //set the base master status code and status for display
        BaseMstr.StatusCode = lStatusCode;
        BaseMstr.StatusComment = strStatusComment;

        BaseMstr.Session["PING_MDWS"] = null;
        
        if (lStatusCode == 0)
        {
            return ds;
        }

        return null;
    }
    
    /// <summary>
    /// US:6002 Gets all note titles for a site/region
    /// </summary>
    /// <param name="BaseMstr"></param>
    /// <param name="lRegionID"></param>
    /// <param name="lSiteID"></param>
    /// <returns></returns>
    public DataSet GetNoteTitleDS(BaseMaster BaseMstr,
                                  string strSearch)
    {
        BaseMstr.Session["PING_MDWS"] = "1";

        //status info
        long lStatusCode = -1;
        string strStatusComment = "";


        //if MDWS transfer is on then move note tiles from MDWS to central db
        //before running query
        if (BaseMstr.MDWSTransfer)
        {
            CMDWSOps ops = new CMDWSOps(BaseMstr.GetDataObject());
            CStatus status = ops.TransferNoteTitles(strSearch);
            if (!status.Status)
            {
                //todo: BaseMstr.ShowSystemFeedback(status.StatusComment, "Data Transfer Error");
            }
        }
        
        //create a new parameter list with standard params from basemstr
        CDataParameterList plist = new CDataParameterList(BaseMstr.ASPSessionID,
                                                          BaseMstr.ClientIP,
                                                          BaseMstr.FXUserID);

        plist.AddInputParameter("pi_nRegionID", BaseMstr.RegionID);
        plist.AddInputParameter("pi_nSiteID", BaseMstr.SiteID);
        plist.AddInputParameter("pi_vSearch", strSearch);

        //call sp to get ds
        CDataSet cds = new CDataSet();
        DataSet ds = cds.GetOracleDataSet(BaseMstr.DBConn,
                                           "PCK_NOTE.GetNoteTitleRS",
                                            plist,
                                            out lStatusCode,
                                            out strStatusComment);

        //set the base master status code and status for display
        BaseMstr.StatusCode = lStatusCode;
        BaseMstr.StatusComment = strStatusComment;

        BaseMstr.Session["PING_MDWS"] = null;
        

        if (lStatusCode == 0)
        {
            return ds;
        }
        
        return null;
      
    }

    /// <summary>
    /// US:6047 get cosigners list based on search criteria
    /// </summary>
    /// <param name="BaseMstr"></param>
    /// <param name="strSearch"></param>
    /// <returns></returns>
    public DataSet GetCosignerDS(BaseMaster BaseMstr,
                                 string strSearch)
    {
        BaseMstr.Session["PING_MDWS"] = "1";

        //status info
        long lStatusCode = -1;
        string strStatusComment = "";


        //if MDWS transfer is on then move note tiles from MDWS to central db
        //before running query
        if (BaseMstr.MDWSTransfer)
        {
            CMDWSOps ops = new CMDWSOps(BaseMstr.GetDataObject());
            CStatus status = ops.TransferUsers(strSearch);
            if (!status.Status)
            {
                //todo: BaseMstr.ShowSystemFeedback(status.StatusComment, "Data Transfer Error");
            }
        }

        //create a new parameter list with standard params from basemstr
        CDataParameterList plist = new CDataParameterList(BaseMstr.ASPSessionID,
                                                          BaseMstr.ClientIP,
                                                          BaseMstr.FXUserID);

        plist.AddInputParameter("pi_nRegionID", BaseMstr.RegionID);
        plist.AddInputParameter("pi_nSiteID", BaseMstr.SiteID);
        plist.AddInputParameter("pi_vSearch", strSearch);

        //call sp to get ds
        CDataSet cds = new CDataSet();
        DataSet ds = cds.GetOracleDataSet(BaseMstr.DBConn,
                                           "PCK_NOTE.GetCosignerRS",
                                            plist,
                                            out lStatusCode,
                                            out strStatusComment);

        //set the base master status code and status for display
        BaseMstr.StatusCode = lStatusCode;
        BaseMstr.StatusComment = strStatusComment;

        BaseMstr.Session["PING_MDWS"] = null;
        
        if (lStatusCode == 0)
        {
            return ds;
        }
        
        return null;
    }


    /// <summary>
    /// US:6005 Gets all patient appointments for a site/region/dfn
    /// </summary>
    /// <param name="BaseMstr"></param>
    /// <param name="lRegionID"></param>
    /// <param name="lSiteID"></param>
    /// <param name="strDFN"></param>
    /// <returns></returns>
    public DataSet GetPatientAppointmentDS(BaseMaster BaseMstr,
                                           DateTime dtFrom,
                                           DateTime dtTo)
    {
        BaseMstr.Session["PING_MDWS"] = "1";

        //status info
        long lStatusCode = -1;
        string strStatusComment = "";

        //if MDWS transfer is on then move note tiles from MDWS to central db
        //before running query
        if (BaseMstr.MDWSTransfer)
        {
            CMDWSOps ops = new CMDWSOps(BaseMstr.GetDataObject());
            CStatus status = ops.TransferPatientAppointments();
            if (!status.Status)
            {
                //todo: BaseMstr.ShowSystemFeedback(status.StatusComment, "Data Transfer Error");
            }
        }
       
        //create a new parameter list with standard params from basemstr
        CDataParameterList plist = new CDataParameterList(BaseMstr.ASPSessionID,
                                                          BaseMstr.ClientIP,
                                                          BaseMstr.FXUserID);

        plist.AddInputParameter("pi_nRegionID", BaseMstr.RegionID);
        plist.AddInputParameter("pi_nSiteID", BaseMstr.SiteID);
        plist.AddInputParameter("pi_vDFN", BaseMstr.DFN);
        plist.AddInputParameter("pi_dtFrom", dtFrom);
        plist.AddInputParameter("pi_dtTo", dtTo);

        //call sp to get ds
        CDataSet cds = new CDataSet();
        DataSet ds = cds.GetOracleDataSet(BaseMstr.DBConn,
                                           "PCK_NOTE.GetPatientAppointmentRS",
                                            plist,
                                            out lStatusCode,
                                            out strStatusComment);

        //set the base master status code and status for display
        BaseMstr.StatusCode = lStatusCode;
        BaseMstr.StatusComment = strStatusComment;

        BaseMstr.Session["PING_MDWS"] = null;
        
        if (lStatusCode == 0)
        {
            return ds;
        }
        
        return null;
    }

    /// <summary>
    /// US:6071 Gets all patient visits for a site/region/dfn
    /// </summary>
    /// <param name="BaseMstr"></param>
    /// <param name="lRegionID"></param>
    /// <param name="lSiteID"></param>
    /// <param name="strDFN"></param>
    /// <returns></returns>
    public DataSet GetPatientVisitDS(BaseMaster BaseMstr,
                                     DateTime dtFrom,
                                     DateTime dtTo)
    {
        BaseMstr.Session["PING_MDWS"] = "1";

        //status info
        long lStatusCode = -1;
        string strStatusComment = "";

        //if MDWS transfer is on then move note tiles from MDWS to central db
        //before running query
        if (BaseMstr.MDWSTransfer)
        {
            CMDWSOps ops = new CMDWSOps(BaseMstr.GetDataObject());
            CStatus status = ops.TransferPatientVisits(dtFrom, dtTo);
            if (!status.Status)
            {
                //todo: BaseMstr.ShowSystemFeedback(status.StatusComment, "Data Transfer Error");
            }
        }
        
        //create a new parameter list with standard params from basemstr
        CDataParameterList plist = new CDataParameterList(BaseMstr.ASPSessionID,
                                                          BaseMstr.ClientIP,
                                                          BaseMstr.FXUserID);

        plist.AddInputParameter("pi_nRegionID", BaseMstr.RegionID);
        plist.AddInputParameter("pi_nSiteID", BaseMstr.SiteID);
        plist.AddInputParameter("pi_vDFN", BaseMstr.DFN);
        plist.AddInputParameter("pi_dtFrom", dtFrom);
        plist.AddInputParameter("pi_dtTo", dtTo);

        //call sp to get ds
        CDataSet cds = new CDataSet();
        DataSet ds = cds.GetOracleDataSet(BaseMstr.DBConn,
                                           "PCK_NOTE.GetPatientVisitRS",
                                            plist,
                                            out lStatusCode,
                                            out strStatusComment);

        //set the base master status code and status for display
        BaseMstr.StatusCode = lStatusCode;
        BaseMstr.StatusComment = strStatusComment;

        BaseMstr.Session["PING_MDWS"] = null;
        
        if (lStatusCode == 0)
        {
            return ds;
        }
        
        return null;
    }

    /// <summary>
    /// US:6007 Gets all patient consults for a site/region/dfn
    /// </summary>
    /// <param name="BaseMstr"></param>
    /// <param name="lRegionID"></param>
    /// <param name="lSiteID"></param>
    /// <param name="strDFN"></param>
    /// <returns></returns>
    public DataSet GetPatientConsultDS(BaseMaster BaseMstr,
                                       DateTime dtFrom,
                                       DateTime dtTo)
    {
        BaseMstr.Session["PING_MDWS"] = "1";

        //status info
        long lStatusCode = -1;
        string strStatusComment = "";

        //if MDWS transfer is on then move note tiles from MDWS to central db
        //before running query
        if (BaseMstr.MDWSTransfer)
        {
            CMDWSOps ops = new CMDWSOps(BaseMstr.GetDataObject());
            CStatus status = ops.TransferPatientConsults();
            if (!status.Status)
            {
                //todo: BaseMstr.ShowSystemFeedback(status.StatusComment, "Data Transfer Error");
            }
        }
        
        //create a new parameter list with standard params from basemstr
        CDataParameterList plist = new CDataParameterList(BaseMstr.ASPSessionID,
                                                          BaseMstr.ClientIP,
                                                          BaseMstr.FXUserID);

        plist.AddInputParameter("pi_nRegionID", BaseMstr.RegionID);
        plist.AddInputParameter("pi_nSiteID", BaseMstr.SiteID);
        plist.AddInputParameter("pi_vDFN", BaseMstr.DFN);
        plist.AddInputParameter("pi_dtFrom", dtFrom);
        plist.AddInputParameter("pi_dtTo", dtTo);

        //call sp to get ds
        CDataSet cds = new CDataSet();
        DataSet ds = cds.GetOracleDataSet(BaseMstr.DBConn,
                                           "PCK_NOTE.GetPatientConsultRS",
                                            plist,
                                            out lStatusCode,
                                            out strStatusComment);

        //set the base master status code and status for display
        BaseMstr.StatusCode = lStatusCode;
        BaseMstr.StatusComment = strStatusComment;

        BaseMstr.Session["PING_MDWS"] = null;
        
        if (lStatusCode == 0)
        {
            return ds;
        }
        
        return null;
    }

    /// <summary>
    /// US:6006 Gets all patient admissions for a site/region/dfn
    /// </summary>
    /// <param name="BaseMstr"></param>
    /// <param name="lRegionID"></param>
    /// <param name="lSiteID"></param>
    /// <param name="strDFN"></param>
    /// <returns></returns>
    public DataSet GetPatientAdmissionDS(BaseMaster BaseMstr,
                                         DateTime dtFrom,
                                         DateTime dtTo)
    {
        BaseMstr.Session["PING_MDWS"] = "1";

        //status info
        long lStatusCode = -1;
        string strStatusComment = "";

        //if MDWS transfer is on then move note tiles from MDWS to central db
        //before running query
        if (BaseMstr.MDWSTransfer)
        {
            CMDWSOps ops = new CMDWSOps(BaseMstr.GetDataObject());
            CStatus status = ops.TransferPatientAdmissions();
            if (!status.Status)
            {
                //todo: BaseMstr.ShowSystemFeedback(status.StatusComment, "Data Transfer Error");
            }
        }
        
        //create a new parameter list with standard params from basemstr
        CDataParameterList plist = new CDataParameterList(BaseMstr.ASPSessionID,
                                                          BaseMstr.ClientIP,
                                                          BaseMstr.FXUserID);

        plist.AddInputParameter("pi_nRegionID", BaseMstr.RegionID);
        plist.AddInputParameter("pi_nSiteID", BaseMstr.SiteID);
        plist.AddInputParameter("pi_vDFN", BaseMstr.DFN);
        plist.AddInputParameter("pi_dtFrom", dtFrom);
        plist.AddInputParameter("pi_dtTo", dtTo);

        //call sp to get ds
        CDataSet cds = new CDataSet();
        DataSet ds = cds.GetOracleDataSet(BaseMstr.DBConn,
                                           "PCK_NOTE.GetPatientAdmissionRS",
                                            plist,
                                            out lStatusCode,
                                            out strStatusComment);

        //set the base master status code and status for display
        BaseMstr.StatusCode = lStatusCode;
        BaseMstr.StatusComment = strStatusComment;

        BaseMstr.Session["PING_MDWS"] = null;
        
        if (lStatusCode == 0)
        {
            return ds;
        }
        
        return null;
    }

}